function JTriStateCheckBox(owner, parent, name, caption, dataset, field, rect, tab, tabStop, tabIndex, align, state)
{
	var self = this,
	_disposed = false,
	_field = null,
	_state = state,
	_form = null;

	this.initialize(owner, parent, name, caption, null, rect, null, field, dataset, tab);

	this.methods  = (cmRender | cmLoad);
	
	this.tabStop  = tabStop;
	this.tabIndex = (tabIndex == null) ? -1 : parseInt(tabIndex);

	this.render = render;
	this.load   = load;
	this.dispose = dispose;
	this.bind_setValue = bind_setValue;
	

	function render(fs)
	{
		if (self.isInvisible())
			return;

		_field = self.dataset.fields[self.field];  

		var addClass = '';

		var chRect = new JRect(self.rect);
		chRect.width = 14;

		var lblRect = new JRect(self.rect);
		lblRect.width -= 22;
		lblRect.top += 2;

		var lblAlign;


		if (align == 'right')
		{
			lblAlign = laRight;
			lblRect.left += 22;
		}
		else
		{
			chRect.left = self.rect.left + self.rect.width - 12;
			lblAlign = laLeft;
		}
		// self.dataset.fields[self.field].caption
		var label = self.owner.registerObject(self.name + "_lbl", new JLabel(self.owner, self.parent, self.name + "_lbl", null, null, self.caption, lblAlign, lblRect, self.tab));
		self.addControl(label);
		label.render(fs);


		fs.append('<div id="' + self.name + '" class="tsChbox tsUnchecked" style="position: absolute; ' + chRect + '" >&nbsp</div>'); 
		// onclick="switchState(this);" onkeydown="handleKeyboard(this, arguments[0]);"
	}

	function load()
	{
		if (self.isInvisible())
			return;

		var elem = self.$$();
		elem.setAttribute('tabIndex', self.tabIndex);
		elem.setAttribute('unselectable', 'on');

		elem.onclick = function(event) { switchState(event, elem); return false; } ;
		elem.onkeydown = function(event) { handleKeyboard(elem, event); return false; };

		_form = self.getForm();
		if ((_form != null) && (_form.setActiveControl))
			elem.onfocus = function() { _form.setActiveControl(self); };

		setState();

		dataset.bindingManager.bind(self, '', self.field);
	}

	function setState()
	{
		var value = self.dataset.get(self.field);
		var sName;
		if (value == '0')
			sName = ' tsUnchecked';
		else
		if (value == '1')
			sName = ' tsChecked';
		else
			sName = ' tsEmpty';

		var	elem = self.$$();
		
		var cName = elem.className;
		elem.className = cName.replace(' tsChecked', '').replace(' tsUnchecked', '').replace(' tsEmpty', '') + sName;

		if ((_form != null) && (_form.checkSaveButton))
			_form.checkSaveButton(self);
	}

	function switchState(e, elem)
	{
		if (!elem)
			elem = self.$$();
		
		var state = '';
		var cName = elem.className;

		var event = e ? e : window.event;
		if ((event) && (event.ctrlKey) && (!self.dataset.isRequired(self.field)))
		{
			state = null;
		}
		else
		if (cName.indexOf(' tsUnchecked') > -1)
		{
			state = '1';
		}
		else
		if (cName.indexOf(' tsEmpty') > -1)
		{
			state = '1';
		}
		else
		if (cName.indexOf(' tsChecked') > -1)
		{
			state = '0';
		}

		self.dataset.set(self.field, state);
	}

	function handleKeyboard(elem, event)
	{
		var key = 0;
		if (event)
		{
			key = event.keyCode;
		}
		else
		if (window.event)
		{
			key = window.event.keyCode;
		}

		if (key == 32)
			switchState(elem);
		else
		if ((key == 46) || (key == 8))  // 46 = Del, 8 = BackSpace
		{
			var cName = elem.className;
			if ((cName.indexOf(' tsEmpty') == -1) && (! self.dataset.isRequired(self.field)))
			{
				elem.className = cName.replace(' tsChecked', '').replace(' tsUnchecked', '') + ' tsEmpty';
				self.dataset.set(self.field, null);
			}
			
		}
	}

	function bind_setValue(prop, field, record)
	{
		setState();
	} 

	function dispose()
	{
		if (_disposed)
			return;

		if ((self.dataset != null) && (self.dataset.bindingManager != null))
			self.dataset.bindingManager.unbind(self);

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JTriStateCheckBox.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();